/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.filed;

import com.ibm.hwmca.base.filed.FileDialogOpenPanelBean;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.task.HwmcaPanelTasklet;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptorDelegate;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.FileUtilities;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class FileDialogTasklet
extends HwmcaPanelTasklet {
    private static final String TRACE_MASKT = "FILEDTTT";
    private static final String TRACE_MASKF = "FILEDTTF";
    private static final String TRACE_MASKD = "FILEDTTD";
    public static final String SOURCE = "com.ibm.hwmca.base.filed.FileDialogTasklet";
    public static final String COMMAND_CANCELLED = "cancelled";
    public static final String COMMAND_GOTDATA = "gotData";
    public static final String KEY_DATA = "data";
    private static final String FILEDIALOG_AUIML = "com.ibm.hwmca.base.filed.res.FileDialogRes";
    private static final String OPEN_PANEL = "OpenPanel";
    private static final String OPEN_PANEL_BEAN = "FileDialogBean";
    private String parentBean = null;
    private static final String KEY_PARENT_BEAN = "parentBean";
    private static final String KEY_PANEL = "panel";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(85, "file dialog");
    public static final String OPENERR_TITLE = "filed.openerr.title";
    public static final String OPENERR_NEEDFILE_TEXT = "filed.openerr.needfile.text";
    public static final String OPENERR_TOOMANYFILE_TEXT = "filed.openerr.toomanyfile.text";
    public static final String OPENERR_MISSINGDIR_TEXT = "filed.openerr.missingdir.text";
    private static final BaseMessageTitle openErrTitle = new BaseMessageTitle("filed.openerr.title");
    private static final MessageText openErrNeedFileText = new BaseMessageText("filed.openerr.needfile.text");
    private static final MessageText openErrTooManyFileText = new BaseMessageText("filed.openerr.toomanyfile.text");

    public static void launchOpenSubtasklet(PanelTaskletResponse response, String _parentBean, boolean _multiSelect, boolean _mustExist) throws TaskletException {
        if (_parentBean == null || _parentBean.equals("")) {
            Trace.trace(TRACE_MASKD, "<>launchOpenSubtasklet: No parent bean name supplied");
            throw new TaskletException("Need parent bean name");
        }
        HashMap<String, Object> initMap = new HashMap<String, Object>();
        initMap.put(KEY_PARENT_BEAN, _parentBean);
        initMap.put(KEY_PANEL, OPEN_PANEL);
        initMap.put("multiSelect", new Boolean(_multiSelect));
        initMap.put("mustExist", new Boolean(_mustExist));
        response.openModalChild(new DisplayAreaDescriptorDelegate(SOURCE, initMap));
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> logException(" + throwable + ")");
        new FrameworkLog(logInfo, 70, throwable).log();
        Trace.trace(TRACE_MASKT, "<- logException()");
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        String source = (String)request.getData("source");
        String cmd = (String)request.getData("command");
        Trace.trace(TRACE_MASKD, "-->service(" + source + "." + cmd + ")");
        if (request.isInitialRequest()) {
            this.parentBean = (String)request.getData(KEY_PARENT_BEAN);
            if (this.parentBean == null) {
                Trace.trace(TRACE_MASKT, "No parent bean name supplied - necessary for FileDialog to respond with data");
                throw new TaskletException("Need parent bean name");
            }
            String panelName = (String)request.getData(KEY_PANEL);
            if (panelName == null || !panelName.equals(OPEN_PANEL)) {
                Trace.trace(TRACE_MASKT, "No panel name supplied - necessary for FileDialog to launch");
                throw new TaskletException("Need panel name");
            }
            Trace.trace(TRACE_MASKD, "Launching FileDialog - parent:" + this.parentBean + " panel:" + panelName);
            if (panelName.equals(OPEN_PANEL)) {
                response.openModalChild(FILEDIALOG_AUIML, panelName, this.getFileDialogOpenPanelBean(request));
            }
        } else if (request.isDisposed() || request.isCanceled()) {
            Trace.trace(TRACE_MASKD, "closing panel: posting TaskletRequest to parent");
            PanelTaskletRequest newReq = new PanelTaskletRequest();
            newReq.setData("source", SOURCE);
            newReq.setData("command", COMMAND_CANCELLED);
            this.parent.postRequest(this.parentBean, newReq);
            response.dispose();
        } else if (source.startsWith(OPEN_PANEL)) {
            this.serviceOpen(request, response);
        } else {
            response.noAction();
        }
        Trace.trace(TRACE_MASKD, "<--service()");
    }

    private void serviceOpen(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        String cmd = (String)request.getData("command");
        Trace.trace(TRACE_MASKD, "--> serviceOpen()");
        if (cmd.endsWith("directory")) {
            String selectedDirPath = (String)request.getData("dirPath");
            HashMap<String, Object> responseMap = new HashMap<String, Object>();
            responseMap.put("fileName", "*");
            try {
                responseMap.put("dirList", this.getDirList(selectedDirPath));
                responseMap.put("fileList", FileUtilities.getFileList(selectedDirPath));
            }
            catch (HException e) {
                Trace.trace(TRACE_MASKT, "exception resolving directory:" + e);
                this.reportBadDir(selectedDirPath, responseMap);
            }
            response.update(responseMap);
        } else if (cmd.equals("OKButton") || cmd.equals("OpenButton")) {
            boolean multiSelect = (Boolean)request.getData("multiSelect");
            boolean mustExist = (Boolean)request.getData("mustExist");
            String fileName = (String)request.getData("fileName");
            String dirPath = (String)request.getData("dirPath");
            ArrayList taskFileList = (ArrayList)request.getData("fileList");
            if (fileName.indexOf("/") != -1) {
                dirPath = fileName.substring(0, fileName.lastIndexOf("/") + 1);
                fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
            }
            if (cmd.equals("OKButton") && !fileName.equals("")) {
                boolean missingDir = false;
                try {
                    taskFileList = FileUtilities.getFileList(dirPath, fileName, true);
                }
                catch (HException e) {
                    Trace.trace(TRACE_MASKT, "exception resolving directory:" + e);
                    missingDir = true;
                }
                if (taskFileList.size() != 1) {
                    HashMap<String, Object> responseMap = new HashMap<String, Object>();
                    responseMap.put("fileName", fileName);
                    try {
                        responseMap.put("dirList", this.getDirList(dirPath));
                        responseMap.put("fileList", taskFileList);
                    }
                    catch (HException e) {
                        Trace.trace(TRACE_MASKT, "exception resolving directory:" + e);
                        missingDir = true;
                    }
                    if (missingDir) {
                        this.reportBadDir(dirPath, responseMap);
                    }
                    response.update(responseMap);
                    Trace.trace(TRACE_MASKD, "<-- serviceOpen(): refresh filelist");
                    return;
                }
            }
            if (taskFileList.size() == 0) {
                try {
                    taskFileList = FileUtilities.getFileList(dirPath, fileName, true);
                }
                catch (HException e) {
                    Trace.trace(TRACE_MASKT, "exception resolving directory:" + e);
                }
            }
            if (mustExist) {
                int i = 0;
                while (i < taskFileList.size()) {
                    File file = new File(dirPath + (String)taskFileList.get(i));
                    if (!file.exists()) {
                        taskFileList.remove(i);
                        continue;
                    }
                    ++i;
                }
            }
            if (taskFileList.size() == 0) {
                this.showMessageBox(true, openErrTitle, openErrNeedFileText, MsgType.ERROR_MESSAGE, null);
                HashMap<String, Object> responseMap = new HashMap<String, Object>();
                responseMap.put("fileName", fileName);
                try {
                    responseMap.put("dirList", this.getDirList(dirPath));
                    responseMap.put("fileList", taskFileList);
                }
                catch (HException e) {
                    Trace.trace(TRACE_MASKT, "exception resolving directory:" + e);
                    this.reportBadDir(dirPath, responseMap);
                }
                response.update(responseMap);
                Trace.trace(TRACE_MASKD, "<-- serviceOpen(): need file selection");
                return;
            }
            if (taskFileList.size() > 1 && !multiSelect) {
                this.showMessageBox(true, openErrTitle, openErrTooManyFileText, MsgType.ERROR_MESSAGE, null);
                HashMap<String, Object> responseMap = new HashMap<String, Object>();
                responseMap.put("fileName", fileName);
                try {
                    responseMap.put("dirList", this.getDirList(dirPath));
                    responseMap.put("fileList", taskFileList);
                }
                catch (HException e) {
                    Trace.trace(TRACE_MASKT, "exception resolving directory:" + e);
                    this.reportBadDir(dirPath, responseMap);
                }
                response.update(responseMap);
                Trace.trace(TRACE_MASKD, "<-- serviceOpen(): too many files selected");
                return;
            }
            ArrayList<String> taskletFileList = new ArrayList<String>();
            Iterator iter = taskFileList.iterator();
            while (iter.hasNext()) {
                taskletFileList.add(dirPath + (String)iter.next());
            }
            Trace.trace(TRACE_MASKD, "posting TaskletRequest to return " + taskletFileList.size() + " filenames to parent");
            PanelTaskletRequest newReq = new PanelTaskletRequest();
            newReq.setData("source", SOURCE);
            newReq.setData("command", COMMAND_GOTDATA);
            newReq.setData(KEY_DATA, taskletFileList);
            this.parent.postRequest(this.parentBean, newReq);
            response.dispose();
        } else {
            response.noAction();
        }
        Trace.trace(TRACE_MASKD, "<-- serviceOpen()");
    }

    private FileDialogOpenPanelBean getFileDialogOpenPanelBean(PanelTaskletRequest request) throws TaskletException {
        Trace.trace(TRACE_MASKD, "<> getFileDialogOpenPanelBean");
        FileDialogOpenPanelBean fdopb = new FileDialogOpenPanelBean();
        fdopb.setPanelName(OPEN_PANEL);
        fdopb.setBeanName(OPEN_PANEL_BEAN);
        fdopb.setMultiSelect((Boolean)request.getData("multiSelect"));
        fdopb.setMustExist((Boolean)request.getData("mustExist"));
        fdopb.setNameEdit("*");
        String initialDirPath = System.getProperty("CONSOLE_PATH");
        if (initialDirPath == null || initialDirPath.equals("")) {
            initialDirPath = "/";
        }
        Trace.trace(TRACE_MASKD, "getFileDialogOpenPanelBean: starting at '" + initialDirPath + "'");
        try {
            fdopb.setDirList(this.getDirList(initialDirPath));
            fdopb.setFileList(FileUtilities.getFileList(initialDirPath));
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKT, "exception resolving directory:" + e);
            Object[] subst = new String[]{initialDirPath};
            try {
                this.showMessageBox(true, openErrTitle, new BaseMessageText(OPENERR_MISSINGDIR_TEXT, subst), MsgType.WARNING_MESSAGE, null);
            }
            catch (TaskletException te) {
                // empty catch block
            }
            ArrayList<String> dirList = new ArrayList<String>();
            dirList.add(initialDirPath);
            fdopb.setDirList(dirList);
            fdopb.setFileList(new ArrayList());
        }
        return fdopb;
    }

    private ArrayList getDirList(String dirPath) throws HException {
        ArrayList dirList = FileUtilities.getDirList(dirPath);
        dirList.add(0, dirPath);
        return dirList;
    }

    private void reportBadDir(String dirPath, Map responseMap) {
        Object[] subst = new String[]{dirPath};
        try {
            this.showMessageBox(true, openErrTitle, new BaseMessageText(OPENERR_MISSINGDIR_TEXT, subst), MsgType.WARNING_MESSAGE, null);
        }
        catch (TaskletException te) {
            // empty catch block
        }
        ArrayList<String> dirList = new ArrayList<String>();
        dirList.add(dirPath);
        responseMap.put("dirList", dirList);
        responseMap.put("fileList", new ArrayList());
    }
}

